//
//  BIPObjectExporter.h
//  BIViews
//
//  Created by Peter Norris on 2014-03-24.
//
//

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

#import <BISubstrate/BIDatabaseObjectContext.h>

typedef enum {
	BIExportTypeCSV = 0,
	BIExportTypeTSV = 1
} BIExportType;

@interface BIPObjectExporter : NSObject
{
    BIDatabaseObjectContext *objectContext;
    
    NSString *directoryPath;
    
    BIExportType currentExportType;
}

@property (nonatomic, strong) BIDatabaseObjectContext *objectContext;
@property (nonatomic, strong) NSString *directoryPath;

- (void)exportAllDataAsCSVWithWindow:(NSWindow *)window;
- (void)exportAllDataAsTSVWithWindow:(NSWindow *)window;

@end
